<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Models\Order;
use Illuminate\Database\Eloquent\Factories\Factory;

class OrderFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Order::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'first_name' => $this->faker->firstName(),
            'last_name' => $this->faker->lastName(),
            'email' => $this->faker->email(),
            'company' => $this->faker->company(),
            'street' => $this->faker->streetName(),
            'street_number' => $this->faker->streetSuffix(),
            'zip' => $this->faker->numberBetween(1000, 9999),
            'city' => $this->faker->city(),
            'country' => 'CH',
            'use_billing_address' => false,
            'billing_company' => null,
            'billing_street' => null,
            'billing_street_number' => null,
            'billing_zip' => null,
            'billing_city' => null,
            'billing_country' => null,
            'shipping_method' => 'post-5',
            'payment_method' => 'testing',
            'amount' => $this->faker->numberBetween(100, 1000),
            'currency' => 'CHF',
            'status' => 'pending',
            'paid_at' => null,
            'customer_id' => function () {
                return Customer::factory()->create();
            },
            'region_id' => 1,
        ];
    }
}
