<?php

return [

    /*
     * This is na array of all the languages available for the website.
     */
    'locales' => ['fr', 'en'],

    /*
     * The default region to use when the shop is "regions aware"
     */
    'default_region' => env('SHOP_DEFAULT_REGION', 'default'),

    'middleware' => [
        'web' => [
            'web',
        ],
    ],

    'cp' => [
        'base_url' => '/cp',
        'guard' => 'cp',
        'preview_url_format' => [
            'fr' => '/{slug}.html',
            'en' => '/en/{slug}.html',
        ],
    ],

    'api' => [
        'enabled' => false,
        'base_url' => '/shop/api',
    ],

    'payment_gateways' => [
        'testing' => \FirstpointCh\Shop\Payment\Gateway\TestGateway::class,
    ],

    'carriers' => [
        'default' => \FirstpointCh\Shop\Carrier\DefaultCarrier::class,
    ],

    'media' => [
        'product' => [
            'conversions' => [
                'thumbnail' => [
                    'width' => 200,
                    'height' => 200,
                ],

                'small' => [
                    'width' => 400,
                    'height' => 400,
                ],

                'medium' => [
                    'width' => 800,
                    'height' => 800,
                ],
            ],
        ],
    ],

];
