<?php

use FirstpointCh\Shop\Checkout;
use FirstpointCh\Shop\Data\Front\CheckoutData;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Order\Enums\OrderStatus;

test('checkout is available from the service container', function () {
    $this->assertInstanceOf(Checkout::class, app('shop::checkout'));
});

test('checkout is available through a helper function', function () {
    $this->assertEquals(app('shop::checkout'), checkout());
});

it('initializes with default values', function () {
    $this->assertEquals(CheckoutData::empty(), app('shop::checkout')->data->toArray());
});

it('loads data from the session', function () {
    session([
        'shop::checkout' => CheckoutData::empty(),
    ]);

    $this->assertEquals(CheckoutData::empty(), app('shop::checkout')->data->toArray());
});

it('stores checkout data into session', function () {
    app('shop::checkout');

    $this->assertEquals(CheckoutData::empty(), session('shop::checkout'));
});

it('updates data', function () {
    $checkout = app('shop::checkout');

    $checkout->update([
        'first_name' => 'Fred',
        'last_name' => 'Marmillod',
    ]);

    $this->assertEquals('Fred', session('shop::checkout.first_name'));
    $this->assertEquals('Marmillod', session('shop::checkout.last_name'));

    $this->assertEquals('Fred', $checkout->data->first_name);
    $this->assertEquals('Marmillod', $checkout->data->last_name);
});

it('doesn\'t update unknown properties', function () {
    $checkout = app('shop::checkout');

    $checkout->update([
        'unknown_property' => 'value',
    ]);

    $this->assertNull(session('shop::checkout.unknown_property'));
})->throws(Exception::class, 'Undefined property Checkout::$unknown_property');

it('resets data', function () {
    $checkout = app('shop::checkout');

    $checkout->update([
        'shipping_method' => 'value',
    ]);

    $this->assertEquals('value', $checkout->data->shipping_method);

    $checkout->reset();

    $this->assertNull($checkout->data->shipping_method);
});

it('returns the current pending order', function () {
    $checkout = app('shop::checkout');

    $order = Order::factory()->create([
        'status' => OrderStatus::Pending,
    ]);

    $checkout->update([
        'order_id' => $order->id,
    ]);

    $this->assertInstanceOf(Order::class, $checkout->getOrder());
    $this->assertEquals($order->id, $checkout->getOrder()->id); // TODO: use "reference" instead
});
