<?php

use FirstpointCh\Shop\Checkout;
use FirstpointCh\Shop\Models\Cart;
use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Models\Region;
use FirstpointCh\Shop\Money;
use FirstpointCh\Shop\Shop;

if (! function_exists('shop')) {
    function shop(): Shop
    {
        return app('shop::shop');
    }
}

if (! function_exists('cart')) {
    function cart(): Cart
    {
        return app('shop::cart')->cart;
    }
}

if (! function_exists('checkout')) {
    /**
     * @param  ?string  $key
     * @return Checkout|mixed
     */
    function checkout(?string $key = null)
    {
        if (! is_null($key)) {
            return app('shop::checkout')->data->{$key};
        }

        return app('shop::checkout');
    }
}

if (! function_exists('customer')) {
    function customer(): Customer
    {
        return auth()->user();
    }
}

if (! function_exists('currency')) {
    function currency()
    {
        return shop()->getRegion()->currency;
    }
}

if (! function_exists('region')) {
    function region(): Region
    {
        return shop()->getRegion();
    }
}

if (! function_exists('money')) {
    function money(): Money
    {
        return app('shop::money');
    }
}
