<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use Illuminate\Http\Request;

class TestGateway extends PaymentGateway
{
    public string $name = 'test-gateway';

    public Payment $payment;

    public function init(Payment $payment): self
    {
        $this->payment = $payment;

        return $this;
    }

    public function fromRequest(Request $request): self
    {
        $this->payment = Payment::where('reference', $request->reference)->first();

        return $this;
    }

    public function redirect()
    {
        return redirect()
            ->route('shop::payment.handle', [
                'gateway' => 'testing',
                'reference' => $this->payment->reference,
            ]);
    }

    public function handle(Request $request): GatewayStatus
    {
        if (empty($this->payment)) {
            return GatewayStatus::Unknown;
        }

        return GatewayStatus::Charged;
    }
}
