<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use FirstpointCh\Shop\Exceptions\PaymentDoesNotExist;
use FirstpointCh\Shop\Models\Payment;
use Illuminate\Http\Request;

class StripeGateway extends PaymentGateway
{
    public string $name = 'stripe';

    public string $handleMode = 'offline';

    public function fromRequest(Request $request): PaymentGateway
    {
        // TODO: Implement fromRequest() method.
    }

    public function redirect()
    {
        \Stripe\Stripe::setApiKey('sk_test_51L8Nf9Asq9DPAJemBsuuiAUoxryD0UA6YxvFsbske7dLkvN2DPCTWyNju031MQW7PRoVeiwTRVNnu4KbOKOqgcLH00ucHpxZFm');

        $session = \Stripe\Checkout\Session::create([
            'line_items' => [[
                'price_data' => [
                    'currency' => $this->payment->currency,
                    'unit_amount' => (int)($this->payment->amount * 100),
                    'product_data' => [
                        'name' => 'Panier #' . $this->payment->cart_id,
                    ],
                ],
                'quantity' => 1,
            ]],
            'mode' => 'payment',
            'success_url' => route('shop::payment.success', ['gateway' => 'stripe']),
            'cancel_url' => 'http://localhost:4242/cancel.html',
        ]);

        return redirect($session->url);
    }

    public function handle(Request $request): GatewayStatus
    {
        // TODO: Implement handle() method.

        return GatewayStatus::Charged;
    }
}
