<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use Illuminate\Http\Request;

abstract class PaymentGateway
{
    public string $name;

    public string $handleMode = 'online';

    public Payment $payment;

    public function init(Payment $payment): self
    {
        $this->payment = $payment;

        return $this;
    }

    abstract public function fromRequest(Request $request): self;

    abstract public function redirect();

    abstract public function handle(Request $request): GatewayStatus;
}
