<?php

namespace FirstpointCh\Shop\Payment\Actions;

use Illuminate\Http\Request;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use FirstpointCh\Shop\Payment\Gateway\PaymentGateway;

class OnlinePaymentHandleAction
{
    public function handle(PaymentGateway $gateway, Request $request)
    {
        switch ($gateway->handle($request)) {
            case GatewayStatus::Success:
            case GatewayStatus::Authorized:
            case GatewayStatus::Charged:
                $order = PaymentIntentSuccessAction::run($gateway->payment);

                cart()->reset();

                return redirect()->route('shop::payment.success', ['gateway' => $gateway->name])->with([
                    'order' => $order,
                ]);
            case GatewayStatus::Failed:
            case GatewayStatus::Error:
            case GatewayStatus::Unknown:
            default:
                abort(403);
        }
    }
}