<?php

namespace FirstpointCh\Shop\Payment\Actions;

use Illuminate\Http\Request;
use FirstpointCh\Shop\Payment\Gateway;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use FirstpointCh\Shop\Payment\Gateway\PaymentGateway;

class OfflinePaymentHandleAction
{
    public function handle(PaymentGateway $gateway, Request $request)
    {
        switch ($gateway->handle($request)) {
            case GatewayStatus::Success:
            case GatewayStatus::Authorized:
            case GatewayStatus::Charged:
                PaymentIntentSuccessAction::run($gateway->payment);
                break;
            case GatewayStatus::Failed:
            case GatewayStatus::Error:
            case GatewayStatus::Unknown:
            default:
                abort(403);
        }
    }
}