<?php

namespace FirstpointCh\Shop\Payment\Actions;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use FirstpointCh\Shop\Models\Cart;
use FirstpointCh\Shop\Actions\Action;

class CreatePaymentIntentAction
{
    use Action;

    public function handle(Cart $cart)
    {
        return DB::transaction(function () use ($cart) {
            // Cancel previous payment
            $cart->payments()->where('status', 'pending')->update([
                'status' => 'cancelled',
            ]);

            // Create new payment
            return $cart->payments()->create([
                'customer_id' => $cart->customer_id,
                'reference' => Str::upper(Str::random(15)), // TODO: Generate unique reference
                'gateway' => $cart->payment_method,
                'amount' => $cart->getTotal(),
                'currency' => $cart->region->currency,
                'status' => 'pending',
            ]);
        });
    }
}
