<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShippingMethod extends Model
{
    use HasFactory, Translatable;

    protected $guarded = [];

    protected $casts = [
        'name' => Localized::class,
        'description' => Localized::class,
    ];

    protected static function booted()
    {
        static::addGlobalScope('region-aware', function ($builder) {
            $builder->when(shop()->isRegionAware(), function ($query) {
                $query->whereRelation('regions', 'region_id', shop()->getRegion()->id);
            });
        });
    }

    public function regions()
    {
        return $this->belongsToMany(Region::class)
            ->withPivot('price');
    }
}
