<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attribute extends Model
{
    use HasFactory, Translatable;

    protected $guarded = [];

    protected $casts = [
        'name' => Localized::class,
        'option_value' => Localized::class,
    ];

    public function products()
    {
        return $this->belongsToMany(Product::class)
            ->withPivot(['value_option_id', 'value_translated', 'value_string', 'value_integer'])
            ->using(AttributeVariant::class);
    }

    public function variants()
    {
        return $this->belongsToMany(Variant::class)
            ->withPivot(['value_option_id', 'value_translated', 'value_string', 'value_integer'])
            ->using(AttributeVariant::class);
    }

    public function productTypes()
    {
        return $this->belongsToMany(ProductType::class)
            ->withTimestamps();
    }

    public function options()
    {
        return $this->hasMany(AttributeOption::class);
    }

    public function getDefaultValue()
    {
        return null;
        // return $this->type === 'translated'
        //     ? [config('app.fallback_locale') => null]
        //     : null;
    }
}
