<?php

namespace FirstpointCh\Shop\Http\Controllers;

use FirstpointCh\Shop\Exceptions\PaymentDoesNotExist;
use FirstpointCh\Shop\Order\Enums\OrderStatus;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use FirstpointCh\Shop\Payment\Gateway;
use Illuminate\Http\Request;
use FirstpointCh\Shop\Payment\Actions\OnlinePaymentHandleAction;
use FirstpointCh\Shop\Payment\Actions\PaymentIntentSuccessAction;
use FirstpointCh\Shop\Payment\Actions\OfflinePaymentHandleAction;

class HandlePaymentController extends Controller
{
    public function __invoke($gateway, Request $request)
    {
        $paymentGateway = Gateway::fromRequest($gateway, $request);

        if ($paymentGateway->handleMode === 'online') {
            return OnlinePaymentHandleAction::run($gateway, $request);
        }

        OfflinePaymentHandleAction::run($gateway, $request);
    }

    public function refreshState(string $gateway)
    {
        ['reference' => $reference] = request()->validate([
            'reference' => 'required'
        ]);

        $payment = cart()->payments()->where('reference', $reference)->firstOrFail();

        if ($payment->status === 'paid') {
            cart()->reset();
        }

        return response()->json([
            'gateway' => $gateway,
            'status' => $payment->status,
            'order' => $payment->order,
        ]);
    }

    public function success(string $gateway)
    {
        $handleMode = (Gateway::make($gateway))->handleMode;

        $order = $handleMode === 'online'
            ? session('order')
            : cart()->order;

        return view('shop::payment.success', [
            'gateway' => $gateway,
            'order' => $order,
        ]);
    }
}
