<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Region;
use Inertia\Inertia;

class RegionController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Region/Index', [
            'regions' => $datatable
                ->searchable(['name'])
                ->performQuery(
                    Region::query()
                ),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('Region/Form');
    }

    public function store()
    {
        Region::create(request()->validate([
            'name' => 'required|max:255',
            'slug' => 'required|max:255',
            'currency' => 'required|size:3',
            'currency_format' => 'required|max:255',
            'available_countries' => 'required|array',
            'available_countries.*' => 'required|size:2',
        ]));

        return redirect('/cp/regions');
    }

    public function edit(Region $region)
    {
        return Inertia::render('Region/Form', [
            'region' => $region,
        ]);
    }

    public function update(Region $region)
    {
        $region->update(request()->validate([
            'name' => 'required|max:255',
            'slug' => 'required|max:255',
            'currency' => 'required|size:3',
            'currency_format' => 'required|max:255',
            'available_countries' => 'required|array',
            'available_countries.*' => 'required|size:2',
        ]));

        return redirect('/cp/regions');
    }
}
