<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use Symfony\Component\Yaml\Yaml;
use Illuminate\Support\Facades\File;
use FirstpointCh\Shop\Models\Page;
use Symfony\Component\Finder\SplFileInfo;
use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use Inertia\Inertia;

class PageController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Page/Index', [
            'pages' => $datatable
                ->searchable(['name'])
                ->performQuery(
                    Page::query()
                ),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        $templates = collect(File::allFiles(base_path('resources/views/cms-templates')))
            ->filter(fn (SplFileInfo $item) => str($item->getFilename())->endsWith('.blade.php'))
            ->values()
            ->map(fn (SplFileInfo $item) => [
                'name' => str_replace('.blade.php', '', $item->getFilename()),
                'fields' => Yaml::parse(
                    File::get(str_replace('.blade.php', '.yaml', $item->getPathname()))
                )['fields'],
            ]);

        return Inertia::render('Page/Form', [
            'templates' => $templates,
        ]);
    }

    public function store()
    {
        Page::create(request()->validate([
            'title' => 'required',
            'slug' => 'required',
            'status' => 'nullable',
            'template' => 'nullable',
            'content' => 'nullable',
        ]));

        return redirect('/cp/pages');
    }

    public function edit(Page $page)
    {
        $templates = collect(File::allFiles(base_path('resources/views/cms-templates')))
            ->filter(fn (SplFileInfo $item) => str($item->getFilename())->endsWith('.blade.php'))
            ->map(fn (SplFileInfo $item) => [
                'name' => str_replace('.blade.php', '', $item->getFilename()),
                'fields' => Yaml::parse(
                    File::get(str_replace('.blade.php', '.yaml', $item->getPathname()))
                )['fields'],
            ]);

        return Inertia::render('Page/Form', [
            'page' => $page->in('*'),
            'templates' => $templates,
        ]);
    }

    public function update(Page $page)
    {
        $page->update(request()->validate([
            'title' => 'required',
            'slug' => 'required',
            'status' => 'nullable',
            'template' => 'nullable',
            'content' => 'nullable',
        ]));

        return redirect('/cp/pages');
    }
}
