<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Brand;
use Inertia\Inertia;

class BrandController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Brand/Index', [
            'brands' => $datatable
                ->searchable(['name'])
                ->performQuery(
                    Brand::query()
                ),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        return Inertia::render('Brand/Form');
    }

    public function store()
    {
        Brand::create(request()->validate([
            'name' => 'required',
        ]));

        return redirect('/cp/brands');
    }

    public function edit(Brand $brand)
    {
        return Inertia::render('Brand/Form', [
            'brand' => $brand,
        ]);
    }

    public function update(Brand $brand)
    {
        $brand->update(request()->validate([
            'name' => 'required',
        ]));

        return redirect('/cp/brands');
    }
}
