# Configuration

You should first publish the assets by running this command

```bash
php artisan shop:publish
```

Then you can open ```config/shop.php```

## Authentication

To allow customers to sign in, you should register the ```Customer``` model in your ```auth.php```:

```php
'defaults' => [
    'guard' => 'web',
    'passwords' => 'customers',
],
'guards' => [
    'web' => [
        'driver' => 'session',
        'provider' => 'customers',
    ],
],
'providers' => [
    // ...
    
    'customers' => [
        'driver' => 'eloquent',
        'model' => FirstpointCh\Shop\Models\Customer::class,
    ],
],

'passwords' => [
    // ...

    'customers' => [
        'provider' => 'customers',
        'table' => 'password_resets',
        'expire' => 0,
        'throttle' => 0,
    ],
],
```