# Shop

## Installation

Add the repository to your composer.json :

```json
"repositories": [
    {
        "type": "composer",
        "url": "https://package.firstpoint.ch"
    }
]
```

Add ```@php artisan shop:publish``` to composer post update commands:

```json
"scripts": {
    "post-update-cmd": [
        "@php artisan vendor:publish --tag=laravel-assets --ansi --force",
        "@php artisan shop:publish"
    ],
}
```

Then run:

```bash
composer require "firstpoint-ch/shop"
```

Run the installer:

```bash
php artisan shop:install
```

## Configuration

Open ```config/shop.php```

## Extend the CP

TODO: Make publishable stubs

Create a ```cp.js``` file in ```resources/js``` folder with the following content:

```js
import CustomPage from './Cp/CustomPage.vue';

Shop.registerPage('CustomPage', CustomPage)
```

Create the vue component:

```vue
<template>
    <div>It Works !</div>
</template>
```

Add the script to ```vite.config.js```

```js
export default defineConfig({
    plugins: [
        laravel([
            ...
            'resources/js/cp.js',
        ]),
...
```

Register the script in a service provider's boot method

```php
public function boot()
{
    app('shop::shop')->registerScripts([
        'resources/js/cp.js',
    ]);
}
```

Compile assets

```bash
npm run build
```

Create a ```routes/cp.php``` with a route to the custom page and return your inertia component:

```php
Route::get('/custom-page', function () {
    return inertia('TestComponent');
});
```

This page is availabe at ```https://yourstore.test/cp/custom-page```
