<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use Arr;
use DB;
use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Http\Requests\DatatableRequest;
use FirstpointCh\Shop\Models\Category;
use FirstpointCh\Shop\Models\CustomField;
use Inertia\Inertia;

class CategoryController extends Controller
{
    public function index(DatatableRequest $datatable)
    {
        return Inertia::render('Category/Index', [
            'categories' => Category::whereNull('parent_id')->with('children')->get(),
            'datatableState' => $datatable->getState(),
        ]);
    }

    public function create()
    {
        $categories = Category::whereNull('parent_id')->with('children')->get();

        return Inertia::render('Category/Form', [
            'categories' => $categories,
            'customFields' => CustomField::all(),
        ]);
    }

    public function store()
    {
        $data = request()->validate([
            'slug' => 'required',
            'name' => 'required',
            'is_active' => 'required',
            'parent_id' => 'nullable',
            'custom_fields' => 'nullable|array',
        ]);

        $customFields = Arr::pull($data, 'custom_fields', []);

        DB::transaction(function () use ($data, $customFields) {
            $category = Category::create($data);
            $category->updateCustomFields($customFields);
            $category->rebuildPath();
        });

        return redirect('/cp/categories');
    }

    public function edit(Category $category)
    {
        $category->load('customFields');

        $categories = Category::whereNull('parent_id')->with('children')->get();

        return Inertia::render('Category/Form', [
            'category' => $category->in('*'),
            'categories' => $categories,
            'customFields' => CustomField::all(),
        ]);
    }

    public function update(Category $category)
    {
        $data = request()->validate([
            'slug' => 'required',
            'name' => 'required',
            'is_active' => 'required',
            'parent_id' => 'nullable',
            'custom_fields' => 'nullable|array',
        ]);

        DB::transaction(function () use ($category, $data) {
            $category->updateCustomFields(Arr::pull($data, 'custom_fields', []));
            $category->update($data);
            $category->rebuildPath();
        });

        return redirect('/cp/categories');
    }
}
