<?php

namespace FirstpointCh\Shop\Commands;

use FirstpointCh\Shop\Models\Category;
use Illuminate\Console\Command;

class RebuildCategoryPaths extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'category:build-paths';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Rebuild category paths';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Category::chunk(100, function ($categories) {
            $categories->each->rebuildPath();
        });

        return 0;
    }
}
