<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <title>Accept a payment</title>
    <meta name="description" content="A demo of a payment on Stripe" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="checkout.css" />
    <script src="https://js.stripe.com/v3/"></script>
    <script src="checkout.js" defer></script>
  </head>
  <body>
        <form id="payment-form">
            <div id="card-element">
                <!-- Elements will create input elements here -->
            </div>

            <!-- We'll put the error messages in this element -->
            <div id="card-errors" role="alert"></div>

            <button id="submit">Submit Payment</button>
        </form>

        <script>
            const stripe = Stripe("{{ $publicKey }}");
            let elements = stripe.elements({ clientSecret: '{{ $clientSecret }}' });

            var card = elements.create("card", {
                style: {
                    base: {
                        color: "#32325d",
                    }
                }
            });

            card.mount("#card-element");

            card.on('change', function(event) {
                var displayError = document.getElementById('card-errors');
                if (event.error) {
                    displayError.textContent = event.error.message;
                } else {
                    displayError.textContent = '';
                }
            });

            var form = document.getElementById('payment-form');

            form.addEventListener('submit', function(ev) {
                ev.preventDefault();
                // If the client secret was rendered server-side as a data-secret attribute
                // on the <form> element, you can retrieve it here by calling `form.dataset.secret`
                stripe.confirmCardPayment('{{ $clientSecret }}', {
                    payment_method: {
                        card: card,
                        billing_details: {
                            name: 'Jenny Rosen'
                        }
                    }
                }).then(function(result) {
                    if (result.error) {
                        // Show error to your customer (for example, insufficient funds)
                        console.log(result.error.message);
                    } else {
                        // The payment has been processed!
                        if (result.paymentIntent.status === 'succeeded') {
                            alert('success')
                            // Show a success message to your customer
                            // There's a risk of the customer closing the window before callback
                            // execution. Set up a webhook or plugin to listen for the
                            // payment_intent.succeeded event that handles any business critical
                            // post-payment actions.
                        }
                    }
                });
            });
        </script>
  </body>
</html>
