<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Coupon\Enums\CouponType;
use FirstpointCh\Shop\Models\Coupon;
use Illuminate\Database\Eloquent\Factories\Factory;

class CouponFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Coupon::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->word,
            'code' => str()->random(5),
            'active_from' => $this->faker->dateTimeBetween('-1 year', 'now'),
            'active_to' => $this->faker->dateTimeBetween('now', '+1 year'),
            'type' => $this->faker->randomElement([
                CouponType::FixedAmount,
                CouponType::Percentage,
            ]),
            'value' => $this->faker->randomFloat(2, 0, 100),
            'usage_limit' => $this->faker->numberBetween(1, 10),
            'current_usage' => 0,
        ];
    }
}
