<?php

return [

    /*
     * This is na array of all the languages available for the website.
     */
    'locales' => [
        'fr' => [
            'name' => 'Français',
            'base_path' => '/',
        ],
        'de' => [
            'name' => 'Deutsch',
            'base_path' => '/de',
        ],
    ],

    /*
     * The default region to use when the shop is "regions aware"
     */
    'default_region' => env('SHOP_DEFAULT_REGION', 'default'),

    'middleware' => [
        'web' => [
            'web',
        ],
    ],

    'cp' => [
        'base_url' => '/cp',
        'guard' => 'cp',
    ],

    'api' => [
        'enabled' => false,
        'base_url' => '/shop/api',
    ],

    'payment_gateways' => [
        \FirstpointCh\Shop\Payment\Gateway\TestGateway::class => [
            'slug' => 'test-gateway',
        ],
        \FirstpointCh\Shop\Payment\Gateway\StripeCheckoutGateway::class => [
            'slug' => 'stripe-checkout',
            'public_key' => env('STRIPE_PUBLIC_KEY'),
            'secret_key' => env('STRIPE_SECRET_KEY'),
            'webhook_secret' => env('STRIPE_WEBHOOK_SECRET'),
        ],
    ],

    'carriers' => [
        'default' => \FirstpointCh\Shop\Carrier\DefaultCarrier::class,
    ],

    'media' => [
        'cms_assets' => [
            'disk' => 'public',
        ],

        'product' => [
            'disk' => 'public',

            'conversions' => [
                'thumbnail' => [
                    'width' => 200,
                    'height' => 200,
                ],

                'small' => [
                    'width' => 400,
                    'height' => 400,
                ],

                'medium' => [
                    'width' => 800,
                    'height' => 800,
                ],
            ],
        ],
    ],

];
