<?php

namespace FirstpointCh\Shop\Payment\Enums;

enum GatewayStatus
{
    /**
     * The order was accepted but no payment has been made yet.
     * Example: bank transfers
     */
    case Success;

    /**
     * The payment was successfully charged.
     */
    case Charged;

    /**
     * The payment was authorized and needs to be captured.
     */
    case Authorized;

    /**
     * The payment was declined.
     */
    case Failed;

    /**
     * There was an error while processing the payment.
     */
    case Error;

    /**
     * The payment status is unknown. It may occure when we can't find the payment.
     */
    case Unknown;

    public function getMessage(): string
    {
        return match ($this) {
            self::Success => __('The order was accepted but no payment has been made yet.'),
            self::Charged => __('The payment was successfully charged.'),
            self::Authorized => __('The payment was authorized.'),
            self::Failed => __('There was an erro during the payment.'),
            self::Error => __('There was an error while processing the payment.'),
            self::Unknown => __('There was an error while processing the payment.'),
        };
    }
}
