<?php

namespace FirstpointCh\Shop\Carrier;

class CarrierManager
{
    protected $carriers = [];

    public function __construct(array $carriers)
    {
        $this->carriers = $carriers;
    }

    public function all(): array
    {
        return array_map(function ($carrier) {
            return new $carrier();
        }, $this->carriers);
    }

    public function get(string $name): Carrier
    {
        if (! isset($this->carriers[$name])) {
            throw new \Exception("Carrier does not exist: {$name}");
        }

        return new $this->carriers[$name]();
    }
}
