<?php

use FirstpointCh\Shop\Models\Product;
use FirstpointCh\Shop\Models\Variant;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->json('meta_title')->nullable();
            $table->json('meta_description')->nullable();
        });

        if (!app()->environment('testing')) {
            Product::query()->update([
                'meta_title' => json_encode([config('app.fallback_locale') => '']),
                'meta_description' => json_encode([config('app.fallback_locale') => '']),
            ]);
        }

        Schema::table('variants', function (Blueprint $table) {
            $table->json('meta_title')->nullable();
            $table->json('meta_description')->nullable();
        });

        if (!app()->environment('testing')) {
            Variant::query()->update([
                'meta_title' => json_encode([config('app.fallback_locale') => '']),
                'meta_description' => json_encode([config('app.fallback_locale') => '']),
            ]);
        }
    }
};
