<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id')->constrained();
            $table->foreignUuid('cart_id');
            $table->foreignId('order_id')->nullable()->constrained()->onDelete('CASCADE');
            $table->string('reference');
            $table->string('gateway');
            $table->decimal('amount');
            $table->char('currency', 3);
            $table->string('status');
            $table->string('status_message')->nullable();
            $table->timestamps();
        });
    }
};
