<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('addresses', function (Blueprint $table) {
            $table->id();
            $table->string('first_name');
            $table->string('last_name');
            $table->string('company')->nullable();
            $table->string('street');
            $table->string('street_number');
            $table->string('zip');
            $table->string('city');
            $table->char('country', 2);

            $table->foreignId('customer_id')->constrained()->onDelete('cascade');

            $table->timestamps();
        });
    }
};
