<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Route;
use Illuminate\Database\Eloquent\Factories\Factory;

class RouteFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Route::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'value' => $this->faker->word(),
            'locale' => 'en',
            'routable_type' => 'FirstpointCh\Shop\Models\Variant',
            'routable_id' => function () {
                return VariantFactory::new()->create();
            },
        ];
    }
}
