<?php

namespace FirstpointCh\Shop\Payment;

use FirstpointCh\Shop\Models\Cart;
use FirstpointCh\Shop\Payment\Gateway\PaymentGateway;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;

class Gateway
{
    public array $gateways = [];

    public function __construct(array $gateways)
    {
        foreach ($gateways as $gateway => $config) {
            $concrete = new $gateway($config);

            $this->gateways[$concrete->slug] = $concrete;
        }
    }

    public function getAvailable(Cart $cart): Collection
    {
        $available = collect();

        foreach ($this->gateways as $gateway) {
            if ($gateway->enabled($cart)) {
                $available->push($gateway);
            }
        }

        return $available;
    }

    public static function make(string $gateway): PaymentGateway
    {
        if (! array_key_exists($gateway, app(self::class)->gateways)) {
            throw new \Exception("Gateway does not exist: {$gateway}");
        }

        return app(self::class)->gateways[$gateway];
    }

    public static function fromRequest($gateway, Request $request): PaymentGateway
    {
        if (! array_key_exists($gateway, app(self::class)->gateways)) {
            throw new \Exception("Gateway does not exist: {$gateway}");
        }

        return app(self::class)->gateways[$gateway]->fromRequest($request);
    }
}
