<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Order\Enums\OrderStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'created_at' => 'datetime',
        'paid_at' => 'datetime',
        'amount' => 'decimal:2',
        'status' => OrderStatus::class,
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function activities()
    {
        return $this->hasMany(OrderActivity::class);
    }

    public function taxes()
    {
        return $this->hasMany(OrderTax::class);
    }

    public function shipments()
    {
        return $this->hasMany(Shipment::class);
    }

    public function totalAmount()
    {
        return $this->amount;
    }
}
