<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('attribute_index', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained('products')->onDelete('cascade');
            $table->foreignId('variant_id')->constrained('variants')->onDelete('cascade');
            $table->foreignId('attribute_id')->constrained('attributes')->onDelete('cascade');
            $table->string('attribute_key');
            $table->string('attribute_type');
            $table->translatable('attribute_name');
            $table->foreignId('value_option_id')->nullable()->constrained('attribute_options')->onDelete('SET NULL');
            $table->json('value_translated')->nullable();
            $table->string('value_string')->nullable();
            $table->bigInteger('value_integer')->nullable();
            $table->timestamps();
        });
    }
};
