<?php

namespace FirstpointCh\Shop\Database\Factories;

use FirstpointCh\Shop\Models\Cart;
use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Models\Region;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CartFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Cart::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'id' => Str::uuid(),
            'customer_id' => function () {
                return Customer::factory()->create();
            },
            'region_id' => function () {
                return Region::factory()->create();
            },
            'is_active' => true,
        ];
    }
}
