<?php

use FirstpointCh\Shop\Models\Attribute;
use FirstpointCh\Shop\Models\Product;
use FirstpointCh\Shop\Models\ProductType;
use FirstpointCh\Shop\Models\Variant;
use Illuminate\Support\Collection;

it('has many variants', function () {
    $product = Product::factory()->create();

    Variant::factory()->create(['product_id' => $product->id]);

    $this->assertCount(1, $product->variants);
    $this->assertInstanceOf(Collection::class, $product->variants);
    $this->assertInstanceOf(Variant::class, $product->variants->first());
});

it('belongs to a product type', function () {
    $productType = ProductType::factory()->create();
    $product = Product::factory()->create(['product_type_id' => $productType->id]);

    $this->assertInstanceOf(ProductType::class, $product->productType);
    $this->assertEquals($productType->id, $product->productType->id);
});

it('belongs to many attributes', function () {
    $product = Product::factory()->create();
    $attribute = Attribute::factory()->create([
        'type' => 'text',
    ]);

    $product->attributes()->attach($attribute->id, ['value_string' => 'foo']);

    $this->assertInstanceOf(Collection::class, $product->attributes);
    $this->assertInstanceOf(Attribute::class, $product->attributes->first());
    $this->assertEquals('foo', $product->attributes->first()->pivot->value_string);
});

// TODO: relations: categories, taxrules
