<?php

use FirstpointCh\Shop\Models\ProductType;
use Inertia\Testing\AssertableInertia;

it('shows the product type index', function () {
    $productType = ProductType::factory()->create();

    $this->get('/cp/product-types')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ProductType/Index')
            ->has('productTypes.data', 1)
            ->where('productTypes.data.0.id', $productType->id)
        );
});

it('searches product types by name', function () {
    $firstProductType = ProductType::factory()->create([
        'name' => 'First ProductType',
    ]);

    $secondProductType = ProductType::factory()->create([
        'name' => 'Second ProductType',
    ]);

    $this->get('/cp/product-types?filters[search]=First%20ProductType')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ProductType/Index')
            ->has('productTypes.data', 1)
            ->where('productTypes.data.0.id', $firstProductType->id)
        );

    $this->get('/cp/product-types?filters[search]=Second%20ProductType')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ProductType/Index')
            ->has('productTypes.data', 1)
            ->where('productTypes.data.0.id', $secondProductType->id)
        );

    $this->get('/cp/product-types?filters[search]=ProductType')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('ProductType/Index')
            ->has('productTypes.data', 2)
        );
});
