<?php

use FirstpointCh\Shop\Models\Product;
use Inertia\Testing\AssertableInertia;

it('shows the product index', function () {
    $product = Product::factory()->create();

    $this->get('/cp/products')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Product/Index')
            ->has('products.data', 1)
            ->where('products.data.0.id', $product->id)
            // TODO: Add product type
        );
});

it('searches products by name', function () {
    $firstProduct = Product::factory()->create([
        'name' => 'First Product',
    ]);

    $secondProduct = Product::factory()->create([
        'name' => 'Second Product',
    ]);

    datatableSearch('/cp/products', 'First Product')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Product/Index')
            ->has('products.data', 1)
            ->where('products.data.0.id', $firstProduct->id)
        );

    datatableSearch('/cp/products', 'Second Product')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Product/Index')
            ->has('products.data', 1)
            ->where('products.data.0.id', $secondProduct->id)
        );

    datatableSearch('/cp/products', 'Product')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Product/Index')
            ->has('products.data', 2)
        );
});
