<?php

use Inertia\Testing\AssertableInertia;

it('shows the brand create form', function () {
    $this->get('/cp/brands/create')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Brand/Form')
        );
});

test('the name is required', function () {
    $this->post('/cp/brands')->assertStatus(302)->assertSessionHasErrors('name');
});

it('stores a new brand', function () {
    $data = [
        'name' => 'My brand',
    ];

    $this->post('/cp/brands', $data)
        ->assertStatus(302)
        ->assertRedirect('/cp/brands');

    $this->assertDatabaseHas('brands', $data);
});
