<?php

namespace FirstpointCh\Shop\Catalog\QueryBuilders;

use FirstpointCh\Shop\Models\Attribute;
use FirstpointCh\Shop\Models\Price;
use Illuminate\Database\Eloquent\Builder;

class VariantQueryBuilder extends Builder
{
    public function withPrice()
    {
        return $this->addSelect(['price' => Price::select('price')
            ->whereColumn('variant_id', 'variants.id')
            ->limit(1),
        ]);
    }

    public function active(bool $active = true)
    {
        return $this->where('is_active', $active);
    }

    public function whereAttributeIn(string $type, string $attribute, array $values, ?string $locale = null)
    {
        return $this->whereHas('attributes', function ($query) use ($type, $attribute, $values, $locale) {
            $query->where('attributes.key', $attribute);

            foreach ($values as $value) {
                $query->orWhere('attribute_variant.value', $value);
            }
        });
    }

    public function wherePriceBetween($min, $max)
    {
        return $this->whereHas('regions', function ($query) use ($min, $max) {
            $query
                ->when(shop()->isRegionAware(), fn ($query) => $query->where('region_id', shop()->getRegion()->id))
                ->when($min, fn ($query) => $query->where('price', '>=', $min))
                ->when($max, fn ($query) => $query->where('price', '<=', $max));
        });
    }

    public function whereAttribute(Attribute $attribute, $value)
    {
        return $this->whereHas('attributes', function ($query) use ($attribute, $value) {
            $query->where('attributes.key', $attribute->key)
                ->where('attribute_variant.value', $value);
        });

        // if ($attribute->type === 'text') {
        //     return $this->whereHas('attributes', function ($query) use ($attribute, $value) {
        //         $query->where('attributes.key', $attribute->key)
        //             ->where('attribute_variant.value_string', $value);
        //     });
        // }

        // if ($attribute->type === 'translated') {
        //     return $this->whereHas('attributes', function ($query) use ($attribute, $value) {
        //         $query->where('attributes.key', $attribute->key)
        //             ->where('attribute_variant.value_translated->'.app()->getLocale(), $value);
        //     });
        // }

        // if ($attribute->type === 'integer') {
        //     return $this->whereHas('attributes', function ($query) use ($attribute, $value) {
        //         $query->where('attributes.key', $attribute->key)
        //             ->where('attribute_variant.value_integer', $value);
        //     });
        // }

        // if ($attribute->type === 'options') {
        //     return $this->whereHas('attributes', function ($query) use ($attribute, $value) {
        //         $query->where('attributes.key', $attribute->key)
        //             ->where('attribute_variant.value_option_id', $value);
        //     });
        // }
    }
}
