<?php

use Illuminate\Support\Str;
use FirstpointCh\Shop\Models\Product;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('products', function (Blueprint $table) {
            $table->json('slug')->nullable()->after('name');
        });

        foreach (Product::all() as $product) {
            $product->in('*');

            foreach ($product->name as $locale => $name) {
                $product->slug[$locale] = Str::slug($name);
            }

            $product->save();
        }

        Schema::table('products', function (Blueprint $table) {
            $table->json('slug')->change();
        });
    }
};
