<?php

namespace FirstpointCh\Shop\Traits;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Factories\HasFactory;

trait HasPackageFactory
{
    use HasFactory;

    protected static function newFactory()
    {
        $package = Str::before(get_called_class(), 'Models\\');
        $modelName = Str::after(get_called_class(), 'Models\\');

        $factory = $package.'Database\\Factories\\'.$modelName.'Factory';

        return $factory::new();
    }
}