<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Relations\Pivot;

class AttributeVariant extends Pivot
{
    use HasPackageFactory, Translatable;

    protected $casts = [
        'value_translated' => Localized::class,
    ];

    public function attribute()
    {
        return $this->belongsTo(Attribute::class);
    }

    public function variant()
    {
        return $this->belongsTo(Variant::class);
    }

    public function option()
    {
        return $this->belongsTo(AttributeOption::class, 'value_option_id');
    }
}
