<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Translatable\Casts\Localized;
use FirstpointCh\Translatable\Traits\Translatable;
use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Relations\Pivot;

class AttributeProduct extends Pivot
{
    use HasPackageFactory, Translatable;

    protected $casts = [
        'value_translated' => Localized::class,
    ];

    public function attribute()
    {
        return $this->belongsTo(Attribute::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function option()
    {
        return $this->belongsTo(AttributeOption::class, 'value_option_id');
    }
}
