<?php

namespace FirstpointCh\Shop\Data\Cp;

use FirstpointCh\Shop\Models\Attribute;
use Spatie\LaravelData\Data;

class DefaultProductAttributeData extends Data
{
    public function __construct(
        public int $attribute_id,
        public string $name,
        public string $type,
        public $options,
        public $value_option_id = null,
        public $value_translated = null,
        public $value_string = null,
        public $value_integer = null,
    ) {
    }

    public static function fromModel(Attribute $attribute): self
    {
        return new self(
            $attribute->id,
            $attribute->name,
            $attribute->type,
            $attribute->options->map->in('*'),
            null,
            [config('app.fallback_locale') => null],
            null,
            null,
        );
    }
}
