<?php

use FirstpointCh\Shop\Models\Attribute;
use Inertia\Testing\AssertableInertia;

it('shows the attribute index', function () {
    $attribute = Attribute::factory()->create();

    $this->get('/cp/attributes')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Attribute/Index')
            ->has('attributes.data', 1)
            ->where('attributes.data.0.id', $attribute->id)
        );
});

it('searches attributes by name', function () {
    $firstAttribute = Attribute::factory()->create([
        'name' => 'First attribute',
    ]);

    $secondAttribute = Attribute::factory()->create([
        'name' => 'Second attribute',
    ]);

    datatableSearch('/cp/attributes', 'First attribute')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Attribute/Index')
            ->has('attributes.data', 1)
            ->where('attributes.data.0.id', $firstAttribute->id)
        );

    datatableSearch('/cp/attributes', 'Second attribute')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Attribute/Index')
            ->has('attributes.data', 1)
            ->where('attributes.data.0.id', $secondAttribute->id)
        );

    datatableSearch('/cp/attributes', 'attribute')
        ->assertStatus(200)
        ->assertInertia(fn (AssertableInertia $page) => $page
            ->component('Attribute/Index')
            ->has('attributes.data', 2)
        );
});
