<?php

namespace FirstpointCh\Shop\Payment\Gateway;

use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Enums\GatewayStatus;
use Illuminate\Http\Request;

class TestGateway extends PaymentGateway
{
    public string $slug = 'test-gateway';

    public string $name = 'Test gateway';

    public string $description = 'This is a test gateway';

    public function fromRequest(Request $request): self
    {
        $this->payment = Payment::where('reference', $request->reference)->first();

        return $this;
    }

    public function redirect(?string $cancelUrl = null)
    {
        return redirect()
            ->route('shop::payment.handle', [
                'gateway' => 'test-gateway',
                'reference' => $this->payment->reference,
            ]);
    }

    public function handle(Request $request): GatewayStatus
    {
        if (empty($this->payment)) {
            return GatewayStatus::Unknown;
        }

        return GatewayStatus::Charged;
    }
}
