<?php

namespace FirstpointCh\Shop\Models;

use FirstpointCh\Shop\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Model;

class ProductType extends Model
{
    use HasPackageFactory;

    protected $guarded = [];

    public function products()
    {
        return $this->hasMany(Product::class);
    }

    public function productAttributes()
    {
        return $this->belongsToMany(Attribute::class)
            ->wherePivot('type', 'product')
            ->withTimestamps();
    }

    public function variantAttributes()
    {
        return $this->belongsToMany(Attribute::class)
            ->wherePivot('type', 'variant')
            ->withTimestamps();
    }

    public function taxRules()
    {
        return $this->belongsToMany(TaxRule::class)
            ->withTimestamps();
    }
}
