<?php

namespace FirstpointCh\Shop\Http\Requests;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;

class DatatableRequest
{
    private $searchable = [];

    private $query;

    private $transformer = null;

    public function searchable(array $searchable)
    {
        $this->searchable = $searchable;

        return $this;
    }

    public function query(Builder $query): self
    {
        $this->query = $query;

        return $this;
    }

    /**
     * @param  callable(Collection):self  $transformer
     * @return $this
     */
    public function transform(callable $transformer): self
    {
        $this->transformer = $transformer;

        return $this;
    }

    public function get()
    {
        if (empty($this->query)) {
            throw new \Exception('Base query not set');
        }

        if ($q = request('filters.search')) {
            $this->query->where(function (Builder $query) use ($q) {
                foreach ($this->searchable as $column) {
                    $query->orWhereRaw("LOWER({$column}) like LOWER('%{$q}%')");
                }
            });
        }

        if ($sortColumn = request('sort.column')) {
            $this->query->orderBy($sortColumn, request('sort.direction'));
        } else {
            $this->query->orderBy('id', 'desc');
        }

        $results = $this->query->paginate(request('perPage', 10), ['*'], 'page');

        if ($this->transformer) {
            $results->setCollection(($this->transformer)($results->getCollection()));
        }

        return $results;
    }

    public function getState()
    {
        $state = request()->only(['filters', 'sort', 'page', 'perPage']);

        return ! empty($state) ? $state : null;
    }
}
