<?php

namespace FirstpointCh\Shop\Http\Controllers;

use FirstpointCh\Shop\Models\Payment;
use FirstpointCh\Shop\Payment\Gateway;
use View;

class PaymentConfirmationController extends Controller
{
    public function __construct(
        public Gateway $gatewayManager
    ) {
    }

    public function __invoke(string $gateway)
    {
        $payment = Payment::where('reference', request()->reference)
            ->where('customer_id', auth()->id())
            ->firstOrFail();

        if ($payment->status === 'paid') {
            cart()->reset();

            return redirect()->route('shop::payment.success', [
                'gateway' => $gateway,
                'reference' => $payment->reference,
            ]);
        }

        if (in_array($payment->status, ['failed', 'error'])) {
            return redirect()->route('shop::payment.error', [
                'gateway' => $gateway,
                'reference' => $payment->reference,
            ]);
        }

        return View::first(["shop::payment.{$gateway}.pending", 'shop::payment.default.pending'], [
            'payment' => $payment,
        ]);
    }

    public function success(string $gateway)
    {
        $payment = Payment::where('reference', request()->reference)
            ->where('customer_id', auth()->id())
            ->where('status', 'paid')
            ->firstOrFail();

        $concreteGateway = $this->gatewayManager->make($gateway);

        return View::first(["shop::payment.{$gateway}.success", 'shop::payment.default.success'], [
            'gateway' => $concreteGateway,
            'payment' => $payment,
        ]);
    }

    public function error(string $gateway)
    {
        $concreteGateway = $this->gatewayManager->make($gateway);

        return View::first(["shop::payment.{$gateway}.error", 'shop::payment.default.error'], [
            'gateway' => $concreteGateway,
            'message' => session('message', 'Une erreur s\'est produite.'),
        ]);
    }
}
