<?php

namespace FirstpointCh\Shop\Http\Controllers\Cp;

use FirstpointCh\Shop\Http\Controllers\Controller;
use FirstpointCh\Shop\Models\Customer;
use FirstpointCh\Shop\Models\Order;
use FirstpointCh\Shop\Models\Region;
use Inertia\Inertia;

class DashboardController extends Controller
{
    public function __invoke()
    {
        $regionSales = [];

        if (config('app.env') === 'testing') {
            // Sqlite doesn't support date functions
            $select = "strftime('%Y', created_at) as year, strftime('%m', created_at) as month, COUNT(*) as total_orders, SUM(amount) as total_amount";
        } else {
            $select = 'YEAR(created_at) as year, MONTH(created_at) as month, COUNT(*) as total_orders, SUM(amount) as total_amount';
        }

        foreach (Region::all() as $region) {
            $results = $region->orders()
                ->selectRaw($select)
                ->groupBy('year', 'month', 'region_id')
                ->orderBy('month', 'desc')
                ->whereYear('created_at', now()->year)
                ->get();

            $amounts = $results->mapWithKeys(function ($order) {
                return [$order->month - 1 => $order->total_amount];
            });

            for ($i = 0; $i < 12; $i++) {
                $amounts[$i] = $amounts[$i] ?? 0;
            }

            $amounts = $amounts->toArray();

            ksort($amounts);

            $regionSales[] = [
                'label' => $region->name,
                'backgroundColor' => '#4338c9',
                'borderColor' => '#4338c9',
                'data' => $amounts,
            ];
        }

        return Inertia::render('Dashboard', [
            'latestOrders' => Order::latest()->take(5)->get(),
            'regionSales' => $regionSales,
            'customerCount' => Customer::count(),
            'paidCount' => Order::where('status', 'paid')->count(),
            'orderCount' => Order::whereMonth('created_at', date('m'))->count(),
        ]);
    }
}
