<?php

namespace FirstpointCh\Shop\Data\Query;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;

class VariantFiltersData extends Data
{
    public function __construct(
        public ?bool $is_active,
        /** @var AttributeFilterData[] */
        public ?DataCollection $attributes,
    ) {
    }

    public static function fromArray(array $filters): static
    {
        return new static(
            $filters['is_active'] ?? null,
            AttributeFilterData::collection($filters['attributes'] ?? []),
        );
    }
}
